/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientSync;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class CustomIngredientImpl
extends class_1856 {
    public static final String TYPE_KEY = "fabric:type";
    public static final int PACKET_MARKER = -1;
    static final Map<class_2960, CustomIngredientSerializer<?>> REGISTERED_SERIALIZERS = new ConcurrentHashMap();
    private final CustomIngredient customIngredient;

    public static void registerSerializer(CustomIngredientSerializer<?> serializer) {
        Objects.requireNonNull(serializer.getIdentifier(), "CustomIngredientSerializer identifier may not be null.");
        if (REGISTERED_SERIALIZERS.putIfAbsent(serializer.getIdentifier(), serializer) != null) {
            throw new IllegalArgumentException("CustomIngredientSerializer with identifier " + String.valueOf(serializer.getIdentifier()) + " already registered.");
        }
    }

    @Nullable
    public static CustomIngredientSerializer<?> getSerializer(class_2960 identifier) {
        Objects.requireNonNull(identifier, "Identifier may not be null.");
        return REGISTERED_SERIALIZERS.get(identifier);
    }

    public CustomIngredientImpl(CustomIngredient customIngredient) {
        super(Stream.empty());
        this.customIngredient = customIngredient;
    }

    public CustomIngredient getCustomIngredient() {
        return this.customIngredient;
    }

    public boolean requiresTesting() {
        return this.customIngredient.requiresTesting();
    }

    public class_1799[] method_8105() {
        if (this.field_9018 == null) {
            this.field_9018 = (class_1799[])this.customIngredient.getMatchingStacks().toArray(class_1799[]::new);
        }
        return this.field_9018;
    }

    public boolean method_8093(@Nullable class_1799 stack) {
        return stack != null && this.customIngredient.test(stack);
    }

    public void method_8088(class_2540 buf) {
        Set<class_2960> supportedIngredients = CustomIngredientSync.CURRENT_SUPPORTED_INGREDIENTS.get();
        if (supportedIngredients != null && !supportedIngredients.contains(this.customIngredient.getSerializer().getIdentifier())) {
            super.method_8088(buf);
        } else {
            buf.method_10804(-1);
            buf.method_10812(this.customIngredient.getSerializer().getIdentifier());
            this.customIngredient.getSerializer().write(buf, (CustomIngredient)this.coerceIngredient());
        }
    }

    public JsonElement method_8089() {
        JsonObject json = new JsonObject();
        json.addProperty(TYPE_KEY, this.customIngredient.getSerializer().getIdentifier().toString());
        this.customIngredient.getSerializer().write(json, (CustomIngredient)this.coerceIngredient());
        return json;
    }

    public boolean method_8103() {
        return this.field_9018 != null && this.field_9018.length == 0;
    }

    private <T> T coerceIngredient() {
        return (T)this.customIngredient;
    }
}

